/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.atmSW;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMWizardInfo;
import ibm.nways.jdm.eui.JDMWizardPanelDelegate;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class PVCCreateWizard
implements JDMWizardPanelDelegate {
    protected static ResourceBundle bundle = ResourceBundle.getBundle("ibm.nways.atmSW.Resources");
    protected JdmBrowser browser;
    protected boolean isVersion3OrGreaterAgent = true;

    public void setDefaults(JDMWizardInfo jDMWizardInfo) {
        Serializable serializable;
        String string = "setDefaults";
        DestinationPropBook destinationPropBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
        this.browser = (JdmBrowser)destinationPropBook.getBrowser();
        GenModel genModel = jDMWizardInfo.getModel();
        Serializable serializable2 = null;
        try {
            serializable = genModel.getInfo("AgentInfo");
            this.isVersion3OrGreaterAgent = this.checkAgentVersion((ModelInfo)serializable);
            serializable2 = ((ModelInfo)serializable).get("AgentInfo.PnniNodeAtmAddress");
        }
        catch (Exception exception) {
            RAS.logException(19, 2, this, string, exception);
        }
        serializable = jDMWizardInfo.getItems();
        ((Hashtable)serializable).put("atmPvcIndex", new Integer(101));
        ((Hashtable)serializable).put("atmPvcIdentifier", new Integer(1));
        ((Hashtable)serializable).put("atmPvcType", new Integer(2));
        ((Hashtable)serializable).put("atmPvcVpi", new Integer(65536));
        ((Hashtable)serializable).put("atmPvcVci", new Integer(65536));
        ((Hashtable)serializable).put("atmPvcBackwardQos", new Integer(0));
        ((Hashtable)serializable).put("atmPvcForwardQos", new Integer(0));
        ((Hashtable)serializable).put("atmPvcBackwardType", new Integer(1));
        ((Hashtable)serializable).put("atmPvcForwardType", new Integer(1));
        ((Hashtable)serializable).put("atmPvcBackwardParam1", new Integer(1000));
        ((Hashtable)serializable).put("atmPvcForwardParam1", new Integer(1000));
        ((Hashtable)serializable).put("atmPvcFrameDiscard", new Integer(0));
        if (serializable2 != null && serializable2 instanceof OctetString) {
            ((Hashtable)serializable).put("atmPvcEpRemAddress", new OctetString(serializable2.toString().substring(0, 26)));
            ((Hashtable)serializable).put("atmPvcEpAtmAddress", serializable2);
        } else {
            ((Hashtable)serializable).put("atmPvcEpRemAddress", new OctetString("00000000000000000000000000"));
            ((Hashtable)serializable).put("atmPvcEpAtmAddress", new OctetString("0000000000000000000000000000000000000000"));
        }
        ((Hashtable)serializable).put("atmPvcEpMode", new Integer(2));
        ((Hashtable)serializable).put("atmPvcEpRemIndex", new Integer(101));
        ((Hashtable)serializable).put("atmPvcEpRemVpi", new Integer(65536));
        ((Hashtable)serializable).put("atmPvcEpRemVci", new Integer(65536));
        this.displayMsg("PVC_createConfirm");
    }

    public boolean abort(JDMWizardInfo jDMWizardInfo) {
        this.displayMsg("PVC_createAbort");
        return true;
    }

    public boolean proceed(JDMWizardInfo jDMWizardInfo) {
        String string;
        boolean bl;
        block22: {
            String string2 = "proceed";
            bl = true;
            GenModel genModel = jDMWizardInfo.getModel();
            Hashtable hashtable = jDMWizardInfo.getItems();
            ModelInfo modelInfo = new ModelInfo();
            string = "PVC_createError";
            this.displayMsg("PVC_creating");
            modelInfo.add("Index.AtmPvcIndex", (Integer)hashtable.get("atmPvcIndex"));
            modelInfo.add("Index.AtmPvcIdentifier", (Integer)hashtable.get("atmPvcIdentifier"));
            modelInfo.add("Panel.AtmPvcRowStatus", new Integer(5));
            try {
                Object object;
                modelInfo = genModel.setInfo("Panel", modelInfo);
                bl = this.checkSetInfo(modelInfo);
                if (!bl) break block22;
                modelInfo.removeAll();
                modelInfo.add("Index.AtmPvcIndex", (Integer)hashtable.get("atmPvcIndex"));
                modelInfo.add("Index.AtmPvcIdentifier", (Integer)hashtable.get("atmPvcIdentifier"));
                modelInfo.add("Panel.AtmPvcType", (Integer)hashtable.get("atmPvcType"));
                modelInfo.add("Panel.AtmPvcVpi", (Integer)hashtable.get("atmPvcVpi"));
                modelInfo.add("Panel.AtmPvcVci", (Integer)hashtable.get("atmPvcVci"));
                modelInfo.add("Panel.AtmPvcBackwardQos", (Integer)hashtable.get("atmPvcBackwardQos"));
                modelInfo.add("Panel.AtmPvcForwardQos", (Integer)hashtable.get("atmPvcForwardQos"));
                Integer n = (Integer)hashtable.get("atmPvcBackwardType");
                Integer n2 = (Integer)hashtable.get("atmPvcForwardType");
                modelInfo.add("Panel.AtmPvcBackwardType", n);
                modelInfo.add("Panel.AtmPvcForwardType", n2);
                if (n != 1) {
                    modelInfo.add("Panel.AtmPvcBackwardParm1", (Integer)hashtable.get("atmPvcBackwardParm1"));
                }
                if (n2 != 1) {
                    modelInfo.add("Panel.AtmPvcForwardParm1", (Integer)hashtable.get("atmPvcForwardParm1"));
                }
                modelInfo.add("Panel.AtmPvcFrameDiscard", (Integer)hashtable.get("atmPvcFrameDiscard"));
                modelInfo = genModel.setInfo("Panel", modelInfo);
                bl = this.checkSetInfo(modelInfo);
                if (!bl) break block22;
                modelInfo.removeAll();
                modelInfo.add("Index.AtmPvcEpIndex", (Integer)hashtable.get("atmPvcIndex"));
                modelInfo.add("Index.AtmPvcEpIdentifier", (Integer)hashtable.get("atmPvcIdentifier"));
                modelInfo.add("Index.AtmPvcEpParty", new Integer(0));
                int n3 = (Integer)hashtable.get("atmPvcEpMode");
                int n4 = (Integer)hashtable.get("atmPvcEpRemIndex");
                String string3 = ((OctetString)hashtable.get("atmPvcEpAtmAddress")).toString();
                String string4 = ((OctetString)hashtable.get("atmPvcEpRemAddress")).toString();
                if (!this.isVersion3OrGreaterAgent && n3 == 1) {
                    string4 = string3.substring(0, 26);
                    try {
                        n4 = Integer.parseInt(string3.substring(36, 38), 16) * 100 + Integer.parseInt(string3.substring(38, 40), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        RAS.logException(19, 2, this, string2, (Exception)numberFormatException);
                    }
                    if (RAS.isEnabled(19, 2)) {
                        RAS.trace(19, 2, this, string2, "Prefix is : " + string4 + " Interface : " + n4);
                    }
                }
                if (this.isVersion3OrGreaterAgent && n3 == 2) {
                    string3 = String.valueOf(string4) + "42000000";
                    object = Integer.toHexString(n4 / 100);
                    String string5 = Integer.toHexString(n4 % 100);
                    if (((String)object).length() == 1) {
                        object = "0" + (String)object;
                    }
                    if (string5.length() == 1) {
                        string5 = "0" + string5;
                    }
                    string3 = String.valueOf(string3) + (String)object + string5 + "00";
                    if (RAS.isEnabled(19, 2)) {
                        RAS.trace(19, 2, this, string2, "ATM Address to be set is : " + string3);
                    }
                }
                if (this.isVersion3OrGreaterAgent) {
                    modelInfo.add("Panel.AtmPvcEpAtmAddress", new OctetString(string3));
                } else {
                    modelInfo.add("Panel.AtmPvcEpAtmAddress", new OctetString(string4));
                    modelInfo.add("Panel.AtmPvcEpRemIndex", new Integer(n4));
                }
                modelInfo.add("Panel.AtmPvcEpRemVpi", (Integer)hashtable.get("atmPvcEpRemVpi"));
                modelInfo.add("Panel.AtmPvcEpRemVci", (Integer)hashtable.get("atmPvcEpRemVci"));
                object = (GenModel)genModel.getComponent("PvcTableRemoteEnd");
                if (object != null) {
                    bl = this.checkSetInfo(modelInfo = object.setInfo("Panel", modelInfo));
                    if (bl) {
                        this.displayMsg("PVC_activating");
                        modelInfo.removeAll();
                        modelInfo.add("Index.AtmPvcIndex", (Integer)hashtable.get("atmPvcIndex"));
                        modelInfo.add("Index.AtmPvcIdentifier", (Integer)hashtable.get("atmPvcIdentifier"));
                        modelInfo.add("Panel.AtmPvcRowStatus", new Integer(1));
                        modelInfo = genModel.setInfo("Panel", modelInfo);
                        bl = this.checkSetInfo(modelInfo);
                        if (!bl) {
                            string = "PVC_createErrorActivate";
                        }
                    } else {
                        string = "PVC_createErrorRemote";
                    }
                } else {
                    if (RAS.isEnabled(19, 2)) {
                        RAS.trace(19, 2, this, string2, "RemoteEnd model is NULL!");
                    }
                    bl = false;
                }
            }
            catch (Exception exception) {
                RAS.logException(19, 2, this, string2, exception);
                bl = false;
            }
        }
        if (!bl) {
            this.displayMsg(string);
        } else {
            this.displayMsg("PVC_createOK");
        }
        return bl;
    }

    private boolean checkSetInfo(ModelInfo modelInfo) {
        String string = "checkSetInfo";
        Enumeration enumeration = modelInfo.getItemIds();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Serializable serializable = modelInfo.get(string2);
            if (!(serializable instanceof SpecialValue)) continue;
            if (RAS.isEnabled(19, 2)) {
                RAS.trace(19, 2, this, string, "Got a special value for ID -> " + string2);
            }
            return false;
        }
        return true;
    }

    protected boolean checkAgentVersion(ModelInfo modelInfo) {
        Serializable serializable = modelInfo.get("AgentInfo.ModuleType1");
        if (serializable instanceof Integer && (Integer)serializable == 6) {
            serializable = modelInfo.get("AgentInfo.ModuleSoftwareVersion1");
            if (serializable instanceof String) {
                String string = (String)((Object)serializable);
                char c = string.charAt(2);
                return c >= '0' && c <= '9' && c >= '3';
            }
            return false;
        }
        serializable = modelInfo.get("AgentInfo.ModuleType9");
        if (serializable instanceof Integer && (Integer)serializable == 2 && (serializable = modelInfo.get("AgentInfo.ModuleOperState9")) instanceof Integer && (Integer)serializable == 2) {
            serializable = modelInfo.get("AgentInfo.ModuleSoftwareVersion9");
            if (serializable instanceof String) {
                String string = (String)((Object)serializable);
                char c = string.charAt(2);
                return c >= '0' && c <= '9' && c >= '3';
            }
            return false;
        }
        serializable = modelInfo.get("AgentInfo.ModuleType11");
        if (serializable instanceof Integer && (Integer)serializable == 2 && (serializable = modelInfo.get("AgentInfo.ModuleOperState11")) instanceof Integer && (Integer)serializable == 2) {
            serializable = modelInfo.get("AgentInfo.ModuleSoftwareVersion11");
            if (serializable instanceof String) {
                String string = (String)((Object)serializable);
                char c = string.charAt(2);
                return c >= '0' && c <= '9' && c >= '3';
            }
            return false;
        }
        return false;
    }

    protected void displayMsg(String string) {
        if (this.browser != null) {
            this.browser.displayMsg(PVCCreateWizard.getNLSString(string));
        }
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = bundle.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }
}

